//====================================================
//KS-23, custom mesh, sounds, & Icons
//====================================================

class WeaponKS23 extends MarkistanCityGuns;

//+++++++++++++
//Icons
//+++++++++++++
#exec TEXTURE IMPORT NAME=BeltIconKS23 FILE=Textures\BeltIconKS23.PCX GROUP=Icons //Belt
#exec TEXTURE IMPORT NAME=InventoryIconKS23 FILE=Textures\InventoryIconKS232.PCX GROUP=Icons //Inventory

//-------------
//Sounds
//-------------

#exec AUDIO IMPORT FILE="C:\DeusEx\MarkistanCity\Sounds\ShotgunFire3.wav" NAME="KS23Fire" GROUP="Weapons"
#exec AUDIO IMPORT FILE="C:\DeusEx\MarkistanCity\Sounds\ShotgunCock.wav" NAME="KS23Cock" GROUP="Weapons"
#exec AUDIO IMPORT FILE="C:\DeusEx\MarkistanCity\Sounds\ShotgunReload.wav" NAME="KS23Reload" GROUP="Weapons"

//================================
// Pickup
//================================

#exec MESH IMPORT MESH=KS23pickup ANIVFILE=MODELS\KS23pickup_a.3d DATAFILE=MODELS\KS23pickup_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=KS23pickup X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=KS23pickup SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=KS23pickup SEQ=KS23Pickup STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=KSGrayAlloy FILE=Textures\KSGrayAlloy.PCX GROUP=Skins // Gray
#exec TEXTURE IMPORT NAME=KSLightGrayAlloy FILE=Textures\KSLightGrayAlloy.PCX GROUP=Skins // Light Gray
#exec TEXTURE IMPORT NAME=KSDarkGrayAlloy FILE=Textures\DarkGrayAlloy.PCX GROUP=Skins // Dark Gray
#exec TEXTURE IMPORT NAME=KSBlackAlloy FILE=Textures\BlackAlloy.PCX GROUP=Skins // Black
#exec TEXTURE IMPORT NAME=KSCusMuz FILE=Textures\CusMuz.PCX GROUP=Skins // Yellow
#exec TEXTURE IMPORT NAME=KSGlovesTex FILE=Textures\GloveEnvMap.PCX GROUP=Skins // Yellow

#exec MESHMAP NEW   MESHMAP=KS23pickup MESH=KS23pickup
//#exec MESHMAP SCALE MESHMAP=KS23pickup X=0.008594025 Y=0.008594025 Z=0.008594025
#exec MESHMAP SCALE MESHMAP=KS23pickup X=0.00730492125 Y=0.00730492125 Z=0.00730492125


#exec MESHMAP SETTEXTURE MESHMAP=KS23pickup NUM=0 TEXTURE=KSLightGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=KS23pickup NUM=1 TEXTURE=KSGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=KS23pickup NUM=2 TEXTURE=KSDarkGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=KS23pickup NUM=3 TEXTURE=KSBlackAlloy

#exec MESHMAP SETTEXTURE MESHMAP=KS23Pickup NUM=4 TEXTURE=BlackMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=KS23Pickup NUM=5 TEXTURE=BlackMaskTex

//================================
// 3rd Person
//================================

#exec MESH IMPORT MESH=KS233rd ANIVFILE=MODELS\KS233rd_a.3d DATAFILE=MODELS\KS233rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=KS233rd X=20 Y=11 Z=4

#exec MESH SEQUENCE MESH=KS233rd SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=KS233rd SEQ=KS233rd STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=KS233rd MESH=KS233rd
//#exec MESHMAP SCALE MESHMAP=KS233rd X=0.008594025 Y=0.008594025 Z=0.008594025
#exec MESHMAP SCALE MESHMAP=KS233rd X=0.00730492125 Y=0.00730492125 Z=0.00730492125

#exec MESHMAP SETTEXTURE MESHMAP=KS233rd NUM=0 TEXTURE=KSLightGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=KS233rd NUM=1 TEXTURE=KSGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=KS233rd NUM=2 TEXTURE=KSDarkGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=KS233rd NUM=3 TEXTURE=KSBlackAlloy

#exec MESHMAP SETTEXTURE MESHMAP=KS233rd NUM=4 TEXTURE=BlackMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=KS233rd NUM=5 TEXTURE=BlackMaskTex

//================================
// 1st Person
//================================

#exec MESH IMPORT MESH=KS231st ANIVFILE=MODELS\KS23_a.3d DATAFILE=MODELS\KS23_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=KS231st X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=KS231st SEQ=All                STARTFRAME=0    NUMFRAMES=1
#exec MESH SEQUENCE MESH=KS231st SEQ=KS231st            STARTFRAME=0    NUMFRAMES=27
#exec MESH SEQUENCE MESH=KS231st SEQ=Select             STARTFRAME=0    NUMFRAMES=6             RATE=12/*RATE=6*/ GROUP=Select
#exec MESH SEQUENCE MESH=KS231st SEQ=Shoot		STARTFRAME=6	NUMFRAMES=6		RATE=10//RATE=5.0769230
#exec MESH SEQUENCE MESH=KS231st SEQ=Down		STARTFRAME=12	NUMFRAMES=3		RATE=6.66
#exec MESH SEQUENCE MESH=KS231st SEQ=ReloadBegin	STARTFRAME=15	NUMFRAMES=4		RATE=8
#exec MESH SEQUENCE MESH=KS231st SEQ=Reload		STARTFRAME=19	NUMFRAMES=3		RATE=1.714285
#exec MESH SEQUENCE MESH=KS231st SEQ=ReloadEnd	        STARTFRAME=22	NUMFRAMES=4		RATE=8
#exec MESH SEQUENCE MESH=KS231st SEQ=Idle1		STARTFRAME=5	NUMFRAMES=1		RATE=2
#exec MESH SEQUENCE MESH=KS231st SEQ=Idle2		STARTFRAME=5	NUMFRAMES=1		RATE=2
#exec MESH SEQUENCE MESH=KS231st SEQ=Idle3		STARTFRAME=5	NUMFRAMES=1		RATE=2
#exec MESH SEQUENCE MESH=KS231st SEQ=Still		STARTFRAME=5	NUMFRAMES=1		RATE=2

#exec MESHMAP NEW   MESHMAP=KS231st MESH=KS231st
#exec MESHMAP SCALE MESHMAP=KS231st X=0.008594025 Y=-0.008594025 Z=0.008594025

#exec MESHMAP SETTEXTURE MESHMAP=KS231st NUM=0 TEXTURE=KSLightGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=KS231st NUM=1 TEXTURE=KSGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=KS231st NUM=2 TEXTURE=KSDarkGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=KS231st NUM=3 TEXTURE=KSBlackAlloy

#exec MESHMAP SETTEXTURE MESHMAP=KS231st NUM=4 TEXTURE=BlackMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=KS231st NUM=5 TEXTURE=BlackMaskTex

//#exec MESHMAP SETTEXTURE MESHMAP=KS231st NUM=5 TEXTURE=SaigaGlovesTex
//#exec MESHMAP SETTEXTURE MESHMAP=KS231st NUM=6 TEXTURE=SaigaGlovesTex

#exec MESH NOTIFY MESH=KS231st SEQ=Shoot	TIME=0.05	FUNCTION=SwapMuzzleFlashTexture
#exec MESH NOTIFY MESH=KS231st SEQ=Shoot	TIME=0.40	FUNCTION=SawedOffCockSound

simulated function SwapMuzzleFlashTexture()
{
   if (!bHasMuzzleFlash)
      return;

	if (Frand() < 0.5)
		MultiSkins[4] = Texture'SaigaCusMuz';
	else
		MultiSkins[5] = Texture'SaigaCusMuz';

	MuzzleFlashLight();
	SetTimer(0.1, False);
}

simulated function EraseMuzzleFlashTexture()
{
	MultiSkins[4] = Texture'BlackMaskTex';
	MultiSkins[5] = Texture'BlackMaskTex';
}

function SpecialPTHShit(actor other, vector hitlocation, vector hitnormal, vector x, vector y, vector z)
{
 
 if (DeusExPlayer(Other) != None && AmmoStar(AmmoType) != None)
 {
  DeusExPlayer(Other).ClientFlash(1500, vect(1000,1000,900));
 }

 Super.SpecialPTHShit(other, hitlocation, hitnormal, x, y, z);
}

function Name WeaponDamageType()
{
 if (AmmoBarricade(AmmoType) != None) //solid steel (chance to gib lol)
 {
  if (FRand() > 0.20)
  {
   return 'Sabot';
  }
  else
  {
  return 'Exploded';
  }
 }
 
 if (AmmoStar(AmmoType) != None) //non-lethal
 {
  return 'KnockedOut';
 }
 
 if (Ammo23mm(AmmoType) != None) //normal
 {
  return 'Shot';
 }
}

defaultproperties
{
     AmmoNames(0)=Class'Ammo23mm'
     AmmoNames(1)=Class'AmmoStar'
     AmmoNames(2)=Class'AmmoBarricade'
     bKnockBack=True
     KnockBackAmount=93
     LowAmmoWaterMark=4
     PenetrationPower=35
     GoverningSkill=Class'DeusEx.SkillWeaponRifle'
     EnviroEffective=ENVEFF_Air
     Concealability=CONC_Visual
     reloadTime=1.850000
     maxRange=2400
     AccurateRange=1200
     BaseAccuracy=0.825000
     AreaOfEffect=AOE_Cone
     recoilStrength=0.500000
     mpHitDamage=13
     mpBaseAccuracy=0.825000
     mpAccurateRange=1200
     mpMaxRange=1200
     mpPickupAmmoCount=12
     bCanHaveModReloadCount=True
     bCanHaveModReloadTime=True
     bCanHaveModRecoilStrength=True
     AmmoName=Class'MarkistanCity.Ammo23mm'
     bInstantHit=True
     FireOffset=(X=-25.000000,Y=15.000000,Z=29.500000)
     shakemag=50.000000
     AltFireSound=Sound'DeusExSounds.Weapons.SawedOffShotgunReloadEnd'
     PlayerViewOffset=(X=25.000000,Y=-15.000000,Z=-26.500000)
     PlayerViewMesh=LodMesh'KS231st'
     PickupViewMesh=LodMesh'KS23Pickup'
     ThirdPersonMesh=LodMesh'KS233rd'
     LandSound=Sound'DeusExSounds.Generic.DropMediumWeapon'
     Icon=Texture'BeltIconKS23'
     largeIcon=Texture'InventoryIconKS23'
     largeIconWidth=131
     largeIconHeight=45
     Mesh=LodMesh'KS23Pickup'
     CollisionRadius=12.325
     CollisionHeight=0.765
     Mass=15.000000
     ShotTime=1.100000
     HitDamage=13
     mpReloadTime=1.850000
     mpReloadCount=3
     ReloadCount=3
     PickupAmmoCount=24
     FireSound=Sound'KS23Fire'
     CockingSound=Sound'KS23Reload'
     SelectSound=Sound'KS23Cock'
     InventoryGroup=203
     ItemName="KS-23 Riot Control Shotgun"
     invSlotsX=3
     Description="The KS-23M shotgun is perhaps the deadliest shotgun in the modern world. Its immense caliber place it at almost 6 guage (american) or 4 guage (european). Oddly enough, the weapon itself is often categorized as a carbine due to its rifle barrel. However, due to its high caliber, it has a very small clip size."
     beltDescription="KS-23"
     Texture=Texture'ReflectionMapTex2'
}
